var mySetting = new aidaSettings();

var keyName = 'DesktopGadgetSettings';
var settingsRegKey = 'HKCU\\Software\\FinalWire\\AIDA64\\';
var WshShell = new ActiveXObject("WScript.Shell");

function aidaSettings()
{ 
	this.bkTopColor = '#1f5797';
	this.bkBottomColor = '#5684b9';
	this.bkHeaderColor = '#e6e9f4';
	this.bkBorderColor = '#235481';
	
	this.showHeader = true;
	this.textAlign = 0;
	this.wrapText = true;
	this.showLabel = true;
}

function stinit() {
	loadSettings();
	settingsShow();
}

System.Gadget.onSettingsClosing = settingsClosing;

function settingsClosing(event)
{
    if (event.closeAction == event.Action.commit)
    {
		try {
			WshShell.RegWrite(settingsRegKey+keyName+'\\'+'bkTopColor',escape(document.getElementById('btop').value),'REG_SZ');
			WshShell.RegWrite(settingsRegKey+keyName+'\\'+'bkBottomColor',escape(document.getElementById('bbottom').value),'REG_SZ');
			WshShell.RegWrite(settingsRegKey+keyName+'\\'+'bkHeaderColor',escape(document.getElementById('hc').value),'REG_SZ');
			WshShell.RegWrite(settingsRegKey+keyName+'\\'+'bkBorderColor',escape(document.getElementById('bc').value),'REG_SZ');
		
			WshShell.RegWrite(settingsRegKey+keyName+'\\'+'showHeader',escape(document.getElementById('showHeader').checked,'REG_SZ'));
			WshShell.RegWrite(settingsRegKey+keyName+'\\'+'textAlign',document.getElementById('textAlign').selectedIndex,'REG_SZ');
			WshShell.RegWrite(settingsRegKey+keyName+'\\'+'wrapText',escape(document.getElementById('wrapText').checked),'REG_SZ');
			WshShell.RegWrite(settingsRegKey+keyName+'\\'+'showLabel',escape(document.getElementById('showLabel').checked),'REG_SZ');
			}
		catch(err) { }
    }
    event.cancel = false;
}

function loadSettings() {
	try {
		mySetting.bkTopColor = unescape(WshShell.RegRead(settingsRegKey+keyName+'\\'+'bkTopColor'));
		mySetting.bkBottomColor = unescape(WshShell.RegRead(settingsRegKey+keyName+'\\'+'bkBottomColor'));
		mySetting.bkHeaderColor = unescape(WshShell.RegRead(settingsRegKey+keyName+'\\'+'bkHeaderColor'));
		mySetting.bkBorderColor = unescape(WshShell.RegRead(settingsRegKey+keyName+'\\'+'bkBorderColor'));
		
		mySetting.showHeader = WshShell.RegRead(settingsRegKey+keyName+'\\'+'showHeader') == 'true';
		mySetting.textAlign = WshShell.RegRead(settingsRegKey+keyName+'\\'+'textAlign');
		mySetting.wrapText = WshShell.RegRead(settingsRegKey+keyName+'\\'+'wrapText') == 'true';
		mySetting.showLabel = WshShell.RegRead(settingsRegKey+keyName+'\\'+'showLabel') == 'true';
		}
	catch(err) { }
}

function settingsShow() {
	document.getElementById('btop').value = mySetting.bkTopColor;
	document.getElementById('bbottom').value = mySetting.bkBottomColor;
	document.getElementById('hc').value = mySetting.bkHeaderColor;
	document.getElementById('bc').value = mySetting.bkBorderColor;
	
	document.getElementById('showHeader').checked = mySetting.showHeader;
	document.getElementById('textAlign').selectedIndex = mySetting.textAlign;
	document.getElementById('wrapText').checked = mySetting.wrapText;
	document.getElementById('showLabel').checked = mySetting.showLabel;
}

function applySelection(item) {
	
	switch (item.selectedIndex) {
	
		case 1: // Black
			bkTopColor = '#303030';
			bkBottomColor = '#000000';
			bkHeaderColor = '#D4D4D4';
			bkBorderColor = '#454545';
		break;
		case 2: // Blue
			bkTopColor = '#1f5797';
			bkBottomColor = '#5684b9';
			bkHeaderColor = '#e6e9f4';
			bkBorderColor = '#235481';
		break;
		case 3: // Dark Blue
			bkTopColor = '#001D3B';
			bkBottomColor = '#000F1F';
			bkHeaderColor = '#D4D4D4';
			bkBorderColor = '#162F45';
		break;
		case 4: // Gold
			bkTopColor = '#f2d300';
			bkBottomColor = '#ffeb64';
			bkHeaderColor = '#B86300';
			bkBorderColor = '#f2d300';
		break;		
		case 5: // Gray
			bkTopColor = '#303030';
			bkBottomColor = '#535353';
			bkHeaderColor = '#FFFFFF';
			bkBorderColor = '#303030';
		break;
		case 6: // Green
			bkTopColor = '#168a2d';
			bkBottomColor = '#369949';
			bkHeaderColor = '#FFFFFF';
			bkBorderColor = '#168a2d';
		break;
		case 7: // Dark Green
			bkTopColor = '#06370f';
			bkBottomColor = '#0f561c';
			bkHeaderColor = '#919191';
			bkBorderColor = '#083b11';
		break;
		case 8: // Orange
			bkTopColor = '#d97500';
			bkBottomColor = '#dca40f';
			bkHeaderColor = '#521300';
			bkBorderColor = '#d97500';
		break;		
		case 9: // Red
			bkTopColor = '#cc0000';
			bkBottomColor = '#cc0000';
			bkHeaderColor = '#FFC917';
			bkBorderColor = '#dc2c2c';
		break;
		case 10: // Silver
			bkTopColor = '#e5e5e5';
			bkBottomColor = '#f4f4f4';
			bkHeaderColor = '#535353';
			bkBorderColor = '#e5e5e5';
		break;
		case 11: // White
			bkTopColor = '#f2f2f2';
			bkBottomColor = '#ffffff';
			bkHeaderColor = '#535353';
			bkBorderColor = '#f2f2f2';
		break;		
	}
	
	document.getElementById('btop').value = bkTopColor;
	document.getElementById('btop').style.backgroundColor = bkTopColor;
	document.getElementById('bbottom').value = bkBottomColor;
	document.getElementById('bbottom').style.backgroundColor = bkBottomColor;
	document.getElementById('hc').value = bkHeaderColor;
	document.getElementById('hc').style.backgroundColor = bkHeaderColor;
	document.getElementById('bc').value = bkBorderColor;
	document.getElementById('bc').style.backgroundColor = bkBorderColor;
}

